(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4203,        143]*)
(*NotebookOutlinePosition[      5092,        173]*)
(*  CellTagsIndexPosition[      5005,        167]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(<< Statistics`DiscreteDistributions`\)], "Input",
  FontFamily->"Arial TUR",
  FontSize->16],

Cell[BoxData[
    \(PoissPDF[k_, N_, dt_, f_] := 
      PDF[PoissonDistribution[N*f*dt], k]\)], "Input",
  FontFamily->"Arial TUR",
  FontSize->16],

Cell[BoxData[
    \(Trigger0[nTh_, N_, dt_, f_] := 
      Evaluate[Sum[
            PoissPDF[k, N, 5/10^9, f]*
              PoissPDF[nTh - k, N, dt, 
                f]*\((1 - Sum[PoissPDF[j, N, 5/10^9, f], {j, 0, k}])\), {k, 
              0, nTh}]]*\((10^9/5)\)\)], "Input",
  FontFamily->"Arial TUR",
  FontSize->16],

Cell[BoxData[
    \(Trigger[nTh_, N_, dt_, f_] := 
      Evaluate[Sum[
            PoissPDF[k, N, 0.0001/10^9, f]*
              PoissPDF[nm - k, N, dt - 0.0001/10^9, 
                f]*\((1 - 
                  Sum[PoissPDF[j, N, 0.0001/10^9, f], {j, 0, 
                      k + nTh - nm}])\), {nm, 0, nTh}, {k, 0, nm}]]*\((10^9/
            0.0001)\)\)], "Input",
  FontFamily->"Arial TUR",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Trigger\)\)], "Input",
  FontFamily->"Arial TUR",
  FontSize->16],

Cell["Global`Trigger", "Print",
  FontFamily->"Arial TUR",
  FontSize->16,
  CellTags->"Info3362411253-9063905"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(Trigger[nTh_, N_, dt_, f_] := 
                    1\/5\ Evaluate[\[Sum]\+\(nm = 0\)\%nTh\(\[Sum]\+\(k = 0\)\
\%nm PoissPDF[k, N, 5\/10\^9, f]\ PoissPDF[nm - k, N, dt - 5\/10\^9, 
                                f]\ \((1 - \[Sum]\+\(j = 0\)\%\(k + nTh - \
nm\)PoissPDF[j, N, 5\/10\^9, f])\)\)]\ 10\^9\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ "Trigger"],
      Editable->False]], "Print",
  FontFamily->"Arial TUR",
  FontSize->16,
  CellTags->"Info3362411253-9063905"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[Trigger0[52, 81000, 425/10^9, 10^3]]\)], "Input",
  FontFamily->"Arial TUR",
  FontSize->16],

Cell[BoxData[
    \(57161.0960845246`\)], "Output",
  FontFamily->"Arial TUR",
  FontSize->16]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[Trigger[52, 81000, 425/10^9, 1\ 10^3]]\)], "Input",
  FontFamily->"Arial TUR",
  FontSize->16],

Cell[BoxData[
    \(93044.35202434182`\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{805, 527},
WindowMargins->{{50, Automatic}, {Automatic, -8}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Info3362411253-9063905"->{
    Cell[2820, 90, 112, 3, 28, "Print",
      CellTags->"Info3362411253-9063905"],
    Cell[2935, 95, 767, 19, 128, "Print",
      CellTags->"Info3362411253-9063905"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Info3362411253-9063905", 4811, 158}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 112, 3, 33, "Input"],
Cell[1820, 55, 147, 4, 33, "Input"],
Cell[1970, 61, 320, 8, 81, "Input"],
Cell[2293, 71, 411, 10, 105, "Input"],

Cell[CellGroupData[{
Cell[2729, 85, 88, 3, 33, "Input"],
Cell[2820, 90, 112, 3, 28, "Print",
  CellTags->"Info3362411253-9063905"],
Cell[2935, 95, 767, 19, 128, "Print",
  CellTags->"Info3362411253-9063905"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3739, 119, 114, 3, 33, "Input"],
Cell[3856, 124, 94, 3, 32, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3987, 132, 116, 3, 33, "Input"],
Cell[4106, 137, 52, 1, 29, "Output"]
}, Open  ]],
Cell[4173, 141, 26, 0, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

